/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.common.utils;

import com.ebaiyihui.common.annotations.DesensitionType;
import com.ebaiyihui.common.annotations.DesensitizationFiled;
import java.lang.reflect.Field;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizationUtils {
    private static final Logger log = LoggerFactory.getLogger(DesensitizationUtils.class);

    public static Object desensitize(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Field[] fields;
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                for (Object item : collection) {
                    DesensitizationUtils.desensitize(item);
                }
                return obj;
            }
            if (obj.getClass().isArray()) {
                Object[] array;
                for (Object item : array = (Object[])obj) {
                    DesensitizationUtils.desensitize(item);
                }
                return obj;
            }
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                if ("serialVersionUID".equals(field.getName())) continue;
                DesensitizationFiled annotation = field.getAnnotation(DesensitizationFiled.class);
                if (annotation == null) {
                    field.setAccessible(true);
                    Object fieldValue = field.get(obj);
                    if (fieldValue == null || DesensitizationUtils.isBasicType(field.getType())) continue;
                    DesensitizationUtils.desensitize(fieldValue);
                    continue;
                }
                if (field.getType() != String.class) continue;
                field.setAccessible(true);
                String value = (String)field.get(obj);
                if (value == null || value.isEmpty()) continue;
                String desensitizedValue = DesensitizationUtils.desensitizeValue(value, annotation.type(), annotation.attach());
                field.set(obj, desensitizedValue);
            }
        }
        catch (Exception e) {
            log.error("\u8131\u654f\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        return obj;
    }

    private static String desensitizeValue(String value, DesensitionType type, String[] attach) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        try {
            if (type == DesensitionType.REAL_NAME) {
                return DesensitizationUtils.desensitizeRealName(value);
            }
            String[] regular = type.getRegular();
            switch (type) {
                case CUSTOM: {
                    if (attach != null && attach.length >= 2) {
                        return value.replaceAll(attach[0], attach[1]);
                    }
                    break;
                }
                case TRUNCATE: {
                    if (attach != null && attach.length > 0) {
                        try {
                            int length = Integer.parseInt(attach[0]);
                            return value.length() > length ? value.substring(0, length) + "..." : value;
                        }
                        catch (NumberFormatException e) {
                            log.warn("\u622a\u53d6\u957f\u5ea6\u53c2\u6570\u65e0\u6548: {}", (Object)attach[0]);
                        }
                    }
                    break;
                }
                default: {
                    if (regular != null && regular.length >= 2) {
                        return value.replaceAll(regular[0], regular[1]);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u8131\u654f\u503c\u5904\u7406\u5931\u8d25, value: {}, type: {}", new Object[]{value, type, e});
        }
        return value;
    }

    private static String desensitizeRealName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        int length = name.length();
        if (length == 1) {
            return name;
        }
        if (length == 2) {
            return name.charAt(0) + "*";
        }
        StringBuilder result = new StringBuilder();
        result.append(name.charAt(0));
        for (int i = 1; i < length - 1; ++i) {
            result.append("*");
        }
        result.append(name.charAt(length - 1));
        return result.toString();
    }

    private static boolean isBasicType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class || Number.class.isAssignableFrom(clazz);
    }
}

