/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.framework.utils.PasswordAndSalt;
import com.ebaiyihui.framework.utils.PasswordUtil;
import com.ebaiyihui.server.config.UniqueID;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.listener.EventManager;
import com.ebaiyihui.server.listener.event.UserRegisterEvent;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcCommunityUserEntity;
import com.ebaiyihui.server.pojo.vo.CommunityAllocationVO;
import com.ebaiyihui.server.pojo.vo.CommunityRegisterVO;
import com.ebaiyihui.server.pojo.vo.UcCommunityUserReqVO;
import com.ebaiyihui.server.pojo.vo.UcCommunityUserVO;
import com.ebaiyihui.server.pojo.vo.UserCommunityVO;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcCommunityUserMapper;
import com.ebaiyihui.server.service.CommunityUserService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class CommunityUserServiceImpl
implements CommunityUserService {
    private static final Logger log = LoggerFactory.getLogger(CommunityUserServiceImpl.class);
    @Autowired
    private UcCommunityUserMapper ucCommunityUserMapper;
    @Autowired
    private UcAccountMapper ucAccountMapper;
    @Autowired
    protected UniqueID uniqueID;
    private static final String PASS_WORD = "123456";
    @Autowired
    private EventManager eventManager;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Integer> register(CommunityRegisterVO registerVO) {
        UcAccountEntity oldAccountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue(), registerVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), registerVO.getRegisterMobile());
        if (oldAccountEntity != null) {
            log.info("\u5f53\u524d\u624b\u673a\u53f7:[{}]\u5df2\u6ce8\u518c\u793e\u533a\u7ba1\u7406\u5458", (Object)registerVO.getRegisterMobile());
            throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
        }
        UcCommunityUserEntity communityUser = new UcCommunityUserEntity();
        BeanUtils.copyProperties((Object)registerVO, (Object)communityUser);
        long userId = this.uniqueID.nextId();
        communityUser.setUserId(String.valueOf(userId));
        this.ucCommunityUserMapper.insertSelective(communityUser);
        log.info("\u793e\u533a\u7ba1\u7406\u5458\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u793e\u533a\u7ba1\u7406\u5458\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)registerVO), (Object)JsonUtil.convertObject((Object)communityUser));
        UcAccountEntity account = this.buildAccountInfo(registerVO, String.valueOf(userId));
        String accountId = String.valueOf(this.uniqueID.nextId());
        account.setAccountId(accountId);
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByAccountId(accountId);
        if (accountEntity != null) {
            account.setId(accountEntity.getId());
        }
        this.ucAccountMapper.save(account);
        log.info("\u65b0\u589e\u8d26\u6237 \u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)registerVO), (Object)JsonUtil.convertObject((Object)account));
        this.ucCommunityUserMapper.unBindCommunity(String.valueOf(userId));
        this.ucCommunityUserMapper.bindCommunity(String.valueOf(userId), registerVO.getCommunityIdList());
        UserRegisterEvent event = new UserRegisterEvent.RegisterBuilder().appCode("NCEFY").accountNo(registerVO.getRegisterMobile()).phone(registerVO.getRegisterMobile()).templateCode("admin_init").builder();
        this.eventManager.post((Object)event);
        return BaseResponse.success((Object)communityUser.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> edit(CommunityRegisterVO registerVO) {
        UcAccountEntity accountEntity;
        boolean accountChange;
        if (Objects.isNull(registerVO.getId())) {
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570,\u7ba1\u7406\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UcCommunityUserEntity oldUserEntity = this.ucCommunityUserMapper.selectByPrimaryKey(registerVO.getId());
        if (oldUserEntity == null) {
            return BaseResponse.error((String)"\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u6ce8\u9500!");
        }
        UcAccountEntity oldAccountEntity = this.ucAccountMapper.findByUserIdAndUserType(oldUserEntity.getUserId(), UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue());
        if (oldAccountEntity == null) {
            return BaseResponse.error((String)"\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u6ce8\u9500!");
        }
        boolean bl = accountChange = !oldAccountEntity.getAccountNo().equals(registerVO.getRegisterMobile());
        if (accountChange && (accountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue(), registerVO.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), registerVO.getRegisterMobile())) != null) {
            log.info("\u5f53\u524d\u624b\u673a\u53f7:[{}]\u5df2\u6ce8\u518c\u793e\u533a\u7ba1\u7406\u5458", (Object)registerVO.getRegisterMobile());
            throw new UserCenterRuntimeException(ErrorEnum.ACCOUNT_REGISTERED);
        }
        oldAccountEntity.setRealName(registerVO.getName());
        oldAccountEntity.setLoginName(registerVO.getName());
        oldAccountEntity.setAccountNo(registerVO.getRegisterMobile());
        oldAccountEntity.setRelatedMobileNumber(registerVO.getRegisterMobile());
        this.ucAccountMapper.updateByPrimaryKeySelective(oldAccountEntity);
        oldUserEntity.setName(registerVO.getName());
        oldUserEntity.setCardNo(registerVO.getCardNo());
        oldUserEntity.setRegisterMobile(registerVO.getRegisterMobile());
        oldUserEntity.setCertification(registerVO.getCertification());
        oldUserEntity.setIdentityFront(registerVO.getIdentityFront());
        oldUserEntity.setIdentityReverse(registerVO.getIdentityReverse());
        this.ucCommunityUserMapper.updateByPrimaryKeySelective(oldUserEntity);
        this.ucCommunityUserMapper.unBindCommunity(oldUserEntity.getUserId());
        this.ucCommunityUserMapper.bindCommunity(oldUserEntity.getUserId(), registerVO.getCommunityIdList());
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseResponse<PageResult<UcCommunityUserVO>> listUser(UcCommunityUserReqVO reqVO) {
        PageHelper.startPage((int)reqVO.getPageNo(), (int)reqVO.getPageSize());
        List communityUserList = this.ucCommunityUserMapper.selectUserByCommunityId(reqVO.getCommunityId());
        PageInfo pageInfo = new PageInfo(communityUserList);
        int total = (int)pageInfo.getTotal();
        PageResult result = new PageResult(reqVO.getPageNo().intValue(), reqVO.getPageSize().intValue());
        result.setTotal(total);
        result.setContent(communityUserList);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<UcCommunityUserVO> getUserDetail(String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570");
        }
        UcCommunityUserVO ucCommunityUser = this.ucCommunityUserMapper.selectUserDetail(userId);
        if (ucCommunityUser == null) {
            return BaseResponse.error((String)"\u5f53\u524d\u8d26\u53f7\u4e0d\u5b58\u5728!");
        }
        return BaseResponse.success((Object)ucCommunityUser);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> allocation(CommunityAllocationVO allocationVO) {
        this.ucCommunityUserMapper.unBindCommunity(allocationVO.getUserId());
        this.ucCommunityUserMapper.bindCommunity(allocationVO.getUserId(), allocationVO.getCommunityIdList());
        return BaseResponse.success((Object)"\u793e\u533a\u5206\u914d\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> setMainCommunity(UserCommunityVO reqVO) {
        UserCommunityVO userVO = this.ucCommunityUserMapper.selectByUserIdAndCommunityId(reqVO);
        if (userVO == null) {
            return BaseResponse.error((String)"\u5f53\u524d\u793e\u533a\u4e0d\u5b58\u5728");
        }
        this.ucCommunityUserMapper.unBindPrimaryCommunity(reqVO.getUserId());
        this.ucCommunityUserMapper.setPrimaryCommunity(reqVO);
        return BaseResponse.success((Object)"\u8bbe\u7f6e\u4e3b\u793e\u533a\u6210\u529f");
    }

    private UcAccountEntity buildAccountInfo(CommunityRegisterVO user, String userId) {
        UcAccountEntity account = new UcAccountEntity();
        account.setAccountNo(user.getRegisterMobile());
        account.setRelatedMobileNumber(user.getRegisterMobile());
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)PASS_WORD);
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        account.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        account.setAppCode(user.getAppCode());
        account.setRegisterChannel("BACKSTAGE_WEB");
        account.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        account.setUserId(userId);
        account.setUserType(UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue());
        return account;
    }
}

