/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.enums.LoginDeviceType;
import com.ebaiyihui.common.pojo.dto.GetUserInfoByPhoneDTO;
import com.ebaiyihui.common.pojo.vo.AddPatientInfoReqVO;
import com.ebaiyihui.common.pojo.vo.AddPatientInfoRespVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.DoctorIdReqVO;
import com.ebaiyihui.common.pojo.vo.DoctorInfoRespVO;
import com.ebaiyihui.common.pojo.vo.FindUserIdListReq;
import com.ebaiyihui.common.pojo.vo.FindUserIdReqVO;
import com.ebaiyihui.common.pojo.vo.FindUserIdRespVO;
import com.ebaiyihui.common.pojo.vo.GetUserInfoReqVO;
import com.ebaiyihui.common.pojo.vo.GetUserLoginInfoReqVO;
import com.ebaiyihui.common.pojo.vo.GetUserLoginInfoRespVO;
import com.ebaiyihui.common.pojo.vo.PatientIdReqVO;
import com.ebaiyihui.common.pojo.vo.PatientInfoVO;
import com.ebaiyihui.common.pojo.vo.QueryPatientInfoListReqVO;
import com.ebaiyihui.common.pojo.vo.QueryPatientInfoListRespVO;
import com.ebaiyihui.common.pojo.vo.UcWxAuthInfo;
import com.ebaiyihui.common.pojo.vo.UnlinkPatientReqVO;
import com.ebaiyihui.common.pojo.vo.UnlinkPatientRespVO;
import com.ebaiyihui.common.pojo.vo.UserInfoRespVO;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceListReqVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceListRespVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceReqVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceRespVo;
import com.ebaiyihui.common.pojo.vo.UserLoginInfo;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyReqVo;
import com.ebaiyihui.common.pojo.vo.UserUniqueIdentifyRespVo;
import com.ebaiyihui.common.pojo.vo.UserUpdateInfoReqVO;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.common.token.exception.TokenParseException;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.DateUtils;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.patient.client.PatientServiceClient;
import com.ebaiyihui.patient.common.enums.PatientErrorEnum;
import com.ebaiyihui.patient.common.vo.BasePatientRespVO;
import com.ebaiyihui.patient.common.vo.GetPatientInfoByCrednoReqVO;
import com.ebaiyihui.patient.common.vo.PatientInfoListReqVO;
import com.ebaiyihui.patient.common.vo.PatientInfoListRespVO;
import com.ebaiyihui.patient.common.vo.PatientInfoRespVO;
import com.ebaiyihui.patient.common.vo.SavePatientInfoReqVo;
import com.ebaiyihui.patient.common.vo.UpdatePatientInfoReqVO;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.CommonEnums;
import com.ebaiyihui.server.enums.LangEnum;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAccountOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcAlipayAuthEntity;
import com.ebaiyihui.server.pojo.entity.UcCommunityUserEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcLoginRecordEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientInfoEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.pojo.entity.UserEntity;
import com.ebaiyihui.server.pojo.vo.IdCardValidateResponseVo;
import com.ebaiyihui.server.pojo.vo.RealNameAuthReqVO;
import com.ebaiyihui.server.repository.AlipayAuthMapper;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.service.IMessageService;
import com.ebaiyihui.server.service.IUserService;
import com.ebaiyihui.server.service.impl.UserServiceImpl;
import com.ebaiyihui.server.util.AliCloudIdCardUtil;
import com.ebaiyihui.server.util.Tokenutil;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl
extends BaseService
implements IUserService {
    @Autowired
    protected ICacheService userICacheService;
    @Autowired
    private IMessageService messageService;
    @Autowired
    private AlipayAuthMapper alipayAuthMapper;
    @Autowired
    private UcWxAuthMapper wxAuthMapper;
    @Autowired
    private PatientServiceClient patientServiceFeginClient;
    @Resource
    private AliCloudIdCardUtil aliCloudIdCardUtil;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> completeUserInfo(UserUpdateInfoReqVO userCompleteInfoReqVO, String token) {
        Short userType = userCompleteInfoReqVO.getUserType();
        String userId = userCompleteInfoReqVO.getUserId();
        List patientInfoList = userCompleteInfoReqVO.getUcPatientInfoList();
        String accountId = userCompleteInfoReqVO.getAccountId();
        UcAccountEntity account = this.getRightAccount(accountId);
        String credNo = userCompleteInfoReqVO.getCredNo();
        String credType = userCompleteInfoReqVO.getCredType();
        if (!(account.getAccountId().equals(accountId) && account.getUserId().equals(userId) && account.getUserType().equals(userType))) {
            this.log.warn("\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7528\u6237id\u4e0e\u8bf7\u6c42\u53c2\u6570\u4e2d\u7528\u6237ID\u4e0d\u4e00\u81f4\uff0c\u8d26\u6237\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)userCompleteInfoReqVO));
            return BaseResponse.error((IError)ErrorEnum.PARAM_CHECK_FAILD);
        }
        if (!UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(userType) && !CollectionUtils.isEmpty((Collection)patientInfoList)) {
            this.log.warn("\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u60a3\u8005\u7528\u6237\u624d\u80fd\u6dfb\u52a0\u60a3\u8005\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)userCompleteInfoReqVO));
            return BaseResponse.error((IError)ErrorEnum.PARAM_CHECK_FAILD);
        }
        if (StringUtils.isEmpty((CharSequence)credNo) && !StringUtils.isEmpty((CharSequence)credType) || StringUtils.isEmpty((CharSequence)credType) && !StringUtils.isEmpty((CharSequence)credNo)) {
            this.log.warn("\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bc1\u4ef6\u53f7\u4e0e\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u8005\u540c\u65f6\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)userCompleteInfoReqVO));
            return BaseResponse.error((IError)ErrorEnum.PARAM_CHECK_FAILD);
        }
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(userType)) {
            this.completePatientInfo(userCompleteInfoReqVO, userId, patientInfoList);
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(userType)) {
            this.completeDoctorInfo(userCompleteInfoReqVO);
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userType)) {
            this.completeManagerInfo(userCompleteInfoReqVO);
        } else {
            this.log.warn("\u9519\u8bef\u7684\u7528\u6237\u7c7b\u578b,\u4e0d\u80fd\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)userCompleteInfoReqVO));
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_USER_TYPE);
        }
        UcAccountOperateEntity accountOperateEntity = new UcAccountOperateEntity(userCompleteInfoReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.PERFECT_INFORMATION.getValue(), "\u5b8c\u5584\u7528\u6237\u4fe1\u606f", accountId, JsonUtil.convertObject((Object)userCompleteInfoReqVO));
        this.ucAccountOperateMapper.save(accountOperateEntity);
        BaseIdRespVO data = new BaseIdRespVO();
        data.setAccountId(accountId);
        data.setUserId(userId);
        return BaseResponse.success((Object)data);
    }

    private void completeManagerInfo(UserUpdateInfoReqVO userCompleteInfoReqVO) {
        UcManagerUserEntity managerUserEntity = this.updateManagerInfo(userCompleteInfoReqVO);
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(managerUserEntity.getUserStatus())) {
            managerUserEntity.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
            this.ucManagerUserMapper.save(managerUserEntity);
        }
    }

    private void completeDoctorInfo(UserUpdateInfoReqVO userCompleteInfoReqVO) {
        UcDoctorUserEntity doctorUserEntity = this.updateDoctorInfo(userCompleteInfoReqVO);
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(doctorUserEntity.getUserStatus())) {
            doctorUserEntity.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
            this.ucDoctorUserMapper.save(doctorUserEntity);
        }
    }

    private void completePatientInfo(UserUpdateInfoReqVO userCompleteInfoReqVO, String userId, List<PatientInfoVO> patientInfoList) {
        UcPatientUserEntity patientUserEntity = this.updatePatientInfo(userCompleteInfoReqVO);
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(patientUserEntity.getUserStatus())) {
            patientUserEntity.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
            this.ucPatientUserMapper.save(patientUserEntity);
            if (!CollectionUtils.isEmpty(patientInfoList)) {
                ArrayList<UcPatientInfoEntity> patientInfoEntities = new ArrayList<UcPatientInfoEntity>();
                for (PatientInfoVO patientInfoVO : patientInfoList) {
                    UcPatientInfoEntity ucPatientInfoEntity = new UcPatientInfoEntity();
                    ucPatientInfoEntity.setPatientId(patientInfoVO.getPatientId());
                    ucPatientInfoEntity.setUserId(userId);
                    ucPatientInfoEntity.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
                    ucPatientInfoEntity.setUserRelation(patientInfoVO.getUserRelation());
                    patientInfoEntities.add(ucPatientInfoEntity);
                }
                this.ucPatientInfoMapper.saveAll(patientInfoEntities);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> updateUserInfo(UserUpdateInfoReqVO userUpdateInfoReqVO, String token) {
        UcPatientUserEntity user;
        String credNo = userUpdateInfoReqVO.getCredNo();
        String credType = userUpdateInfoReqVO.getCredType();
        if (StringUtils.isEmpty((CharSequence)credNo) && !StringUtils.isEmpty((CharSequence)credType) || StringUtils.isEmpty((CharSequence)credType) && !StringUtils.isEmpty((CharSequence)credNo)) {
            this.log.warn("\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bc1\u4ef6\u53f7\u4e0e\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u8005\u540c\u65f6\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)userUpdateInfoReqVO));
            return BaseResponse.error((IError)ErrorEnum.PARAM_CHECK_FAILD);
        }
        String accountId = userUpdateInfoReqVO.getAccountId();
        UcAccountEntity account = this.getRightAccount(accountId);
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(userUpdateInfoReqVO.getUserType())) {
            user = this.updatePatientInfo(userUpdateInfoReqVO);
            this.ucPatientUserMapper.save(user);
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(userUpdateInfoReqVO.getUserType())) {
            user = this.updateDoctorInfo(userUpdateInfoReqVO);
            this.ucDoctorUserMapper.save((UcDoctorUserEntity)user);
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(userUpdateInfoReqVO.getUserType())) {
            user = this.updateManagerInfo(userUpdateInfoReqVO);
            this.ucManagerUserMapper.save((UcManagerUserEntity)user);
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userUpdateInfoReqVO.getUserType())) {
            user = this.updateOrganInfo(userUpdateInfoReqVO);
            this.ucOrganUserMapper.save((UcOrganUserEntity)user);
        } else {
            throw new UserCenterRuntimeException(ErrorEnum.UNKNOWN_USER_TYPE);
        }
        UcAccountOperateEntity accountOperate = new UcAccountOperateEntity(userUpdateInfoReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_USER_INFO.getValue(), "\u4fee\u6539\u4e2a\u4eba\u8d44\u6599", accountId, JsonUtil.convertObject((Object)userUpdateInfoReqVO));
        this.ucAccountOperateMapper.save(accountOperate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<UserInfoRespVO> getUserInfo(GetUserInfoReqVO getUserInfoReqVO) {
        UserEntity userEntity = this.getUserEntity(getUserInfoReqVO.getUserId(), getUserInfoReqVO.getUserType());
        if (userEntity == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}]" + getUserInfoReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcAccountEntity account = this.getAccountByUserId(getUserInfoReqVO.getUserId(), getUserInfoReqVO.getUserType(), getUserInfoReqVO.getAppCode());
        if (account == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u8d26\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f={}", (Object)getUserInfoReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.NO_EXISTS_ACCOUNT);
        }
        UserInfoRespVO userInfoRespVO = this.getUserInfoRespVO(userEntity, getUserInfoReqVO.getUserType());
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(getUserInfoReqVO.getUserType())) {
            this.handlePatientInfo((UcPatientUserEntity)userEntity, userInfoRespVO);
        }
        userInfoRespVO.setAccountNo(account.getAccountNo());
        UcWxAuthInfo ucWxAuthInfo = new UcWxAuthInfo();
        ucWxAuthInfo.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
        if (getUserInfoReqVO.getSubordinateType() != null) {
            Optional optional = this.ucWxAuthMapper.findByUserIdAndUserTypeAndSubordinateType(getUserInfoReqVO.getUserId(), getUserInfoReqVO.getUserType(), getUserInfoReqVO.getSubordinateType());
            if (optional.isPresent()) {
                UcWxAuthEntity ucWxAuthEntity = (UcWxAuthEntity)optional.get();
                if (WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue().equals(ucWxAuthEntity.getStatus())) {
                    BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)ucWxAuthInfo);
                } else {
                    ucWxAuthInfo.setStatus(ucWxAuthEntity.getStatus());
                }
            }
        } else {
            ucWxAuthInfo.setStatus(WxAuthEnums.WxAuthStatusEnum.UNRELATED.getValue());
        }
        this.log.info("\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u63a5\u53e3==\u5fae\u4fe1\u6388\u6743\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)ucWxAuthInfo));
        userInfoRespVO.setWxAuthInfo(ucWxAuthInfo);
        userInfoRespVO.setAccountType(account.getAccountType());
        userInfoRespVO.setRelatedMobileNumber(account.getRelatedMobileNumber());
        return BaseResponse.success((Object)userInfoRespVO);
    }

    private void handlePatientInfo(UcPatientUserEntity userEntity, UserInfoRespVO userInfoRespVO) {
        UcPatientUserEntity patientUser = userEntity;
        List patientInfoList = this.ucPatientInfoMapper.findListByUserIdAndPatientInfoStatus(patientUser.getUserId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        if (patientInfoList != null && patientInfoList.size() > 0) {
            ArrayList<PatientInfoVO> patientInfoVOList = new ArrayList<PatientInfoVO>();
            for (UcPatientInfoEntity ucPatientInfoEntity : patientInfoList) {
                PatientInfoVO patientInfoVO = new PatientInfoVO();
                patientInfoVO.setPatientId(ucPatientInfoEntity.getPatientId());
                patientInfoVO.setUserRelation(ucPatientInfoEntity.getUserRelation());
                patientInfoVOList.add(patientInfoVO);
            }
            userInfoRespVO.setPatientInfos(patientInfoVOList);
        }
    }

    public UserEntity getUserEntity(String userId, UserEnums.UserTypeEnum userType) {
        UcCommunityUserEntity userEntity = null;
        switch (1.$SwitchMap$com$ebaiyihui$server$enums$UserEnums$UserTypeEnum[userType.ordinal()]) {
            case 1: {
                Optional patientUser = this.ucPatientUserMapper.findByUserId(userId);
                userEntity = patientUser.orElse(null);
                break;
            }
            case 2: {
                Optional doctorUser = this.ucDoctorUserMapper.selectByUserId(userId);
                userEntity = doctorUser.orElse(null);
                break;
            }
            case 3: {
                Optional managerUser = this.ucManagerUserMapper.selectByUserId(userId);
                userEntity = managerUser.orElse(null);
                break;
            }
            case 4: {
                Optional organUser = this.ucOrganUserMapper.selectByUserId(userId);
                userEntity = organUser.orElse(null);
                break;
            }
            case 5: {
                userEntity = this.ucCommunityUserMapper.selectUserEntityByUserId(userId);
                break;
            }
        }
        if (userEntity == null) {
            this.log.warn("\u7528\u6237\u4e0d\u5b58\u5728\uff0cuserId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        Short userStatus = userEntity.getUserStatus();
        UserEnums.UserStatusEnum userStatusEnum = UserEnums.UserStatusEnum.getByStatusValue((Short)userStatus);
        switch (1.$SwitchMap$com$ebaiyihui$server$enums$UserEnums$UserStatusEnum[userStatusEnum.ordinal()]) {
            case 1: {
                this.log.warn("\u7528\u6237\u5df2\u6ce8\u9500\uff0cuserId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.CANCELED_USER);
            }
            case 2: {
                this.log.warn("\u7528\u6237\u5df2\u7981\u7528\uff0cuserId={}", (Object)userId);
                throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER);
            }
        }
        return userEntity;
    }

    public UserInfoRespVO getUserInfoRespVO(UserEntity userEntity, Short userType) {
        UserInfoRespVO userInfoRespVO = new UserInfoRespVO();
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(userType)) {
            UcPatientUserEntity patientUserEntity = (UcPatientUserEntity)userEntity;
            userInfoRespVO.setUserId(patientUserEntity.getUserId());
            userInfoRespVO.setBirthDate(DateUtils.formatDateDefault((Date)patientUserEntity.getDob()));
            userInfoRespVO.setContactMobile(patientUserEntity.getContactMobile());
            userInfoRespVO.setCredNo(patientUserEntity.getCredNo());
            userInfoRespVO.setCredType(patientUserEntity.getCredType());
            userInfoRespVO.setEmail(patientUserEntity.getEmail());
            userInfoRespVO.setGender(patientUserEntity.getGender());
            userInfoRespVO.setHeadPortrait(patientUserEntity.getHeadPortrait());
            userInfoRespVO.setIntroduction(patientUserEntity.getPersonalizedSignature());
            userInfoRespVO.setName(patientUserEntity.getName());
            userInfoRespVO.setNation(patientUserEntity.getNation());
            userInfoRespVO.setNickName(patientUserEntity.getNickname());
            userInfoRespVO.setRealnameId(patientUserEntity.getRealnameId());
            userInfoRespVO.setRealnameStatus(patientUserEntity.getRealnameStatus());
            userInfoRespVO.setRegisterMobile(patientUserEntity.getRegisterMobile());
            userInfoRespVO.setUserStatus(patientUserEntity.getUserStatus());
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(userType)) {
            UcDoctorUserEntity doctorUserEntity = (UcDoctorUserEntity)userEntity;
            userInfoRespVO.setUserId(doctorUserEntity.getUserId());
            userInfoRespVO.setBirthDate(DateUtils.formatDateDefault((Date)doctorUserEntity.getDob()));
            userInfoRespVO.setContactMobile(doctorUserEntity.getContactMobile());
            userInfoRespVO.setCredNo(doctorUserEntity.getCredNo());
            userInfoRespVO.setCredType(doctorUserEntity.getCredType());
            userInfoRespVO.setDataId(doctorUserEntity.getDoctorId());
            userInfoRespVO.setEmail(doctorUserEntity.getEmail());
            userInfoRespVO.setGender(doctorUserEntity.getGender());
            userInfoRespVO.setHeadPortrait(doctorUserEntity.getHeadPortrait());
            userInfoRespVO.setIntroduction(doctorUserEntity.getPersonalizedSignature());
            userInfoRespVO.setName(doctorUserEntity.getName());
            userInfoRespVO.setNation(doctorUserEntity.getNation());
            userInfoRespVO.setNickName(doctorUserEntity.getNickname());
            userInfoRespVO.setRealnameId(doctorUserEntity.getRealnameId());
            userInfoRespVO.setRealnameStatus(doctorUserEntity.getRealnameStatus());
            userInfoRespVO.setRegisterMobile(doctorUserEntity.getRegisterMobile());
            userInfoRespVO.setUserStatus(doctorUserEntity.getUserStatus());
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userType)) {
            UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)userEntity;
            userInfoRespVO.setUserId(managerUserEntity.getUserId());
            userInfoRespVO.setBirthDate(DateUtils.formatDateDefault((Date)managerUserEntity.getDob()));
            userInfoRespVO.setContactMobile(managerUserEntity.getContactMobile());
            userInfoRespVO.setCredNo(managerUserEntity.getCredNo());
            userInfoRespVO.setCredType(managerUserEntity.getCredType());
            userInfoRespVO.setDataId(managerUserEntity.getBaseId());
            userInfoRespVO.setEmail(managerUserEntity.getEmail());
            userInfoRespVO.setGender(managerUserEntity.getGender());
            userInfoRespVO.setHeadPortrait(managerUserEntity.getHeadPortrait());
            userInfoRespVO.setName(managerUserEntity.getName());
            userInfoRespVO.setNation(managerUserEntity.getNation());
            userInfoRespVO.setRealnameId(managerUserEntity.getRealnameId());
            userInfoRespVO.setRealnameStatus(managerUserEntity.getRealnameStatus());
            userInfoRespVO.setRegisterMobile(managerUserEntity.getRegisterMobile());
            userInfoRespVO.setUserStatus(managerUserEntity.getUserStatus());
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(userType)) {
            UcOrganUserEntity organUserEntity = (UcOrganUserEntity)userEntity;
            userInfoRespVO.setUserId(organUserEntity.getUserId());
            userInfoRespVO.setContactMobile(organUserEntity.getContactMobile());
            userInfoRespVO.setDataId(organUserEntity.getOrganId());
            userInfoRespVO.setHeadPortrait(organUserEntity.getOrganIcon());
            userInfoRespVO.setName(organUserEntity.getOrganName());
            userInfoRespVO.setIntroduction(organUserEntity.getBriefIntroduction());
            userInfoRespVO.setUserStatus(organUserEntity.getUserStatus());
        } else if (UserEnums.UserTypeEnum.COMMUNITY.getUserTypeValue().equals(userType)) {
            UcCommunityUserEntity communityUserEntity = new UcCommunityUserEntity();
            BeanUtils.copyProperties((Object)userEntity, (Object)communityUserEntity);
            userInfoRespVO.setUserId(communityUserEntity.getUserId());
            userInfoRespVO.setContactMobile(communityUserEntity.getRegisterMobile());
            userInfoRespVO.setName(communityUserEntity.getName());
            userInfoRespVO.setCredNo(communityUserEntity.getCardNo());
            userInfoRespVO.setUserStatus(communityUserEntity.getUserStatus());
        }
        return userInfoRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<UnlinkPatientRespVO> unlinkPatientInfo(UnlinkPatientReqVO unlinkPatientReqVO, String accessToken) {
        String accountId = unlinkPatientReqVO.getAccountId();
        String userId = unlinkPatientReqVO.getUserId();
        String patientId = unlinkPatientReqVO.getPatientId();
        this.getRightAccount(accountId);
        this.getPatientUserEntity(userId);
        UcPatientInfoEntity patientInfoEntity = this.ucPatientInfoMapper.getPatientInfoByUIdandPIdandPS(userId, patientId, UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        if (patientInfoEntity == null) {
            this.log.warn("\u89e3\u9664\u60a3\u8005\u4fe1\u606f\u7ed1\u5b9a\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u60a3\u8005\u7ed1\u5b9a\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)unlinkPatientReqVO));
            return BaseResponse.error((IError)ErrorEnum.PATIENT_NOT_BIND);
        }
        patientInfoEntity.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding());
        this.ucPatientInfoMapper.save(patientInfoEntity);
        TokenJson tokenJson = this.getTokenJson(accessToken, unlinkPatientReqVO.getAppCode());
        String tokenKey = Tokenutil.genTokenKey((String)userId, (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.userICacheService.getLoginToken(tokenKey);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.ULINK_PATIENT);
        this.messageService.patientActionMsg(userId, patientId, UserEnums.PatientInfoStatusEnum.UNBINGDING);
        UcPatientOperateEntity patientOperateEntity = new UcPatientOperateEntity(accountId, userId, patientId, patientInfoEntity.getId(), UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding(), UserEnums.PatientOperatorEnum.USER.getUserType());
        this.ucPatientOperateMapper.save(patientOperateEntity);
        UnlinkPatientRespVO data = new UnlinkPatientRespVO();
        data.setAccountId(accountId);
        data.setUserId(userId);
        data.setPatientId(patientId);
        return BaseResponse.success((Object)data);
    }

    private UcPatientUserEntity updatePatientInfo(UserUpdateInfoReqVO userUpdateInfoReqVO) {
        UcPatientUserEntity user = this.getPatientUserEntity(userUpdateInfoReqVO.getUserId());
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(user.getUserStatus())) {
            user.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        }
        if (StringUtils.isEmpty((CharSequence)user.getRealnameId())) {
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getName())) {
                user.setName(userUpdateInfoReqVO.getName());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getNation())) {
                user.setNation(userUpdateInfoReqVO.getNation());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredNo()) && !StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredType())) {
                user.setCredNo(userUpdateInfoReqVO.getCredNo());
                user.setCredType(userUpdateInfoReqVO.getCredType());
            }
            if (userUpdateInfoReqVO.getGender() != null) {
                user.setGender(userUpdateInfoReqVO.getGender());
            }
            if (userUpdateInfoReqVO.getBirthDay() != null) {
                user.setDob(userUpdateInfoReqVO.getBirthDay());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getRealnameId())) {
                user.setRealnameId(userUpdateInfoReqVO.getRealnameId());
                user.setRealnameStatus(UserEnums.RealnameStatusEnum.REALNAMED.getRealnameStatus());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getHeadPortrait())) {
            user.setHeadPortrait(userUpdateInfoReqVO.getHeadPortrait());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getContactMobile())) {
            user.setContactMobile(userUpdateInfoReqVO.getContactMobile());
        }
        return user;
    }

    private UcDoctorUserEntity updateDoctorInfo(UserUpdateInfoReqVO userUpdateInfoReqVO) {
        UcDoctorUserEntity user = this.getDoctorUserEntity(userUpdateInfoReqVO.getUserId());
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(user.getUserStatus())) {
            user.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        }
        if (StringUtils.isEmpty((CharSequence)user.getRealnameId())) {
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getName())) {
                user.setName(userUpdateInfoReqVO.getName());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getNation())) {
                user.setNation(userUpdateInfoReqVO.getNation());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredNo()) && !StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredType())) {
                user.setCredNo(userUpdateInfoReqVO.getCredNo());
                user.setCredType(userUpdateInfoReqVO.getCredType());
            }
            if (userUpdateInfoReqVO.getGender() != null) {
                user.setGender(userUpdateInfoReqVO.getGender());
            }
            if (userUpdateInfoReqVO.getBirthDay() != null) {
                user.setDob(userUpdateInfoReqVO.getBirthDay());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getRealnameId())) {
                user.setRealnameId(userUpdateInfoReqVO.getRealnameId());
                user.setRealnameStatus(UserEnums.RealnameStatusEnum.REALNAMED.getRealnameStatus());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getHeadPortrait())) {
            user.setHeadPortrait(userUpdateInfoReqVO.getHeadPortrait());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getContactMobile())) {
            user.setContactMobile(userUpdateInfoReqVO.getContactMobile());
        }
        return user;
    }

    private UcManagerUserEntity updateManagerInfo(UserUpdateInfoReqVO userUpdateInfoReqVO) {
        UcManagerUserEntity user = this.getManagerUserEntity(userUpdateInfoReqVO.getUserId());
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(user.getUserStatus())) {
            user.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        }
        if (StringUtils.isEmpty((CharSequence)user.getRealnameId())) {
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getName())) {
                user.setName(userUpdateInfoReqVO.getName());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getNation())) {
                user.setNation(userUpdateInfoReqVO.getNation());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredNo()) && !StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getCredType())) {
                user.setCredNo(userUpdateInfoReqVO.getCredNo());
                user.setCredType(userUpdateInfoReqVO.getCredType());
            }
            if (userUpdateInfoReqVO.getGender() != null) {
                user.setGender(userUpdateInfoReqVO.getGender());
            }
            if (userUpdateInfoReqVO.getBirthDay() != null) {
                user.setDob(userUpdateInfoReqVO.getBirthDay());
            }
            if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getRealnameId())) {
                user.setRealnameId(userUpdateInfoReqVO.getRealnameId());
                user.setRealnameStatus(UserEnums.RealnameStatusEnum.REALNAMED.getRealnameStatus());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getHeadPortrait())) {
            user.setHeadPortrait(userUpdateInfoReqVO.getHeadPortrait());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getContactMobile())) {
            user.setContactMobile(userUpdateInfoReqVO.getContactMobile());
        }
        return user;
    }

    private UcOrganUserEntity updateOrganInfo(UserUpdateInfoReqVO userUpdateInfoReqVO) {
        UcOrganUserEntity user = this.getOrganUserEntity(userUpdateInfoReqVO.getUserId());
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        if (UserEnums.UserStatusEnum.IMPERFECT.getUserStatusValue().equals(user.getUserStatus())) {
            user.setUserStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getName())) {
            user.setOrganIcon(userUpdateInfoReqVO.getHeadPortrait());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getHeadPortrait())) {
            user.setOrganIcon(userUpdateInfoReqVO.getHeadPortrait());
        }
        if (!StringUtils.isEmpty((CharSequence)userUpdateInfoReqVO.getContactMobile())) {
            user.setContactMobile(userUpdateInfoReqVO.getContactMobile());
        }
        return user;
    }

    public BaseResponse<List<QueryPatientInfoListRespVO>> findPatientInfoList(QueryPatientInfoListReqVO reqVO) {
        String userId = reqVO.getUserId();
        UserEntity userEntity = this.getUserEntity(userId, UserEnums.UserTypeEnum.PATIENT);
        if (userEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0cuserId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        List patientInfoEntities = this.ucPatientInfoMapper.findByUserId(userId);
        List patientInfoListRespVOs = this.getPatientListReq(patientInfoEntities, reqVO);
        List respVOs = this.convertPatientInfoListRespVO(patientInfoListRespVOs);
        this.log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0c\u60a3\u8005\u670d\u52a1\u8fd4\u56de={}", (Object)patientInfoListRespVOs);
        return BaseResponse.success((Object)respVOs);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<AddPatientInfoRespVO> bindingPatient(AddPatientInfoReqVO reqVO) {
        List patientInfoEntityList;
        UcPatientUserEntity patientUserEntity = this.getPatientUserEntity(reqVO.getUserId());
        Optional optionalList = this.ucPatientInfoMapper.findByUserIdAndPatientInfoStatus(reqVO.getUserId(), Short.valueOf((short)0));
        if (optionalList.isPresent() && !(patientInfoEntityList = (List)optionalList.get()).isEmpty() && patientInfoEntityList.size() > 5) {
            this.log.error("\u7ed1\u5b9a\u60a3\u8005\u5f02\u5e38\uff1abindingPatient \u7528\u6237\u53ef\u7ed1\u5b9a\u7684\u60a3\u8005\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650(5\u4e2a),\u5165\u53c2AddPatientInfoReqVO:{} ", (Object)reqVO);
            return BaseResponse.error((IError)ErrorEnum.PATIENT_BIND_FULL);
        }
        BaseResponse patientInfoBycredNo = this.getPatientInfoByCred(reqVO);
        if (patientInfoBycredNo.isSuccess()) {
            PatientInfoRespVO patientInfoRespVO = (PatientInfoRespVO)patientInfoBycredNo.getData();
            this.log.info("\u5f53\u524d\u60a3\u8005\u5b58\u5728\uff0cAddPatientInfoReqVO[{}],PatientInfoRespVO[{}]", (Object)reqVO, (Object)patientInfoRespVO);
            return this.alreadyPatient(reqVO, patientUserEntity, patientInfoRespVO);
        }
        if (PatientErrorEnum.PATIENT_NOT_EXIT.getErrCode().equals(patientInfoBycredNo.getErrCode())) {
            SavePatientInfoReqVo patientInfo = new SavePatientInfoReqVo();
            BeanUtils.copyProperties((Object)reqVO, (Object)patientInfo);
            BaseResponse savePatientInfo = this.patientServiceFeginClient.savePatientInfo(patientInfo);
            if (savePatientInfo.isSuccess()) {
                BasePatientRespVO patientInfoData = (BasePatientRespVO)savePatientInfo.getData();
                AddPatientInfoRespVO addPatientInfoRespVO = this.getAddPatientInfoRespVO(reqVO, patientUserEntity, patientInfoData.getPatientId());
                this.log.info("\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0cpatientInfoEntity[{}]", (Object)patientInfo);
                this.messageService.patientActionMsg(addPatientInfoRespVO.getUserId(), addPatientInfoRespVO.getPatientId(), UserEnums.PatientInfoStatusEnum.BINDING);
                UcAccountEntity account = this.getAccountByUserId(reqVO.getUserId(), UserEnums.UserTypeEnum.PATIENT.getUserTypeValue(), reqVO.getAppCode());
                if (account == null) {
                    this.log.error("\u60a3\u8005\u4e2d\u5fc3\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u5927\u4f17\u8d26\u6237,userId={},appCode={}", (Object)reqVO.getUserId(), (Object)reqVO.getAppCode());
                    return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
                }
                UcPatientOperateEntity patientOperateEntity = new UcPatientOperateEntity(account.getAccountId(), reqVO.getUserId(), addPatientInfoRespVO.getPatientId(), addPatientInfoRespVO.getPatientInfoId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding(), UserEnums.PatientOperatorEnum.USER.getUserType());
                this.ucPatientOperateMapper.save(patientOperateEntity);
                return BaseResponse.success((Object)addPatientInfoRespVO);
            }
            this.log.error("\u60a3\u8005\u4e2d\u5fc3\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u5931\u8d25\uff0csavePatientInfo[{}]", (Object)savePatientInfo);
            return BaseResponse.error((IError)ErrorEnum.SAVE_PATIENT_EER);
        }
        this.log.error("\u67e5\u8be2\u60a3\u8005\u4e2d\u5fc3\u662f\u5426\u5b58\u5728\u8be5\u60a3\u8005\u9519\u8bef\uff0cgetErrCode[{}],Msg[{}],reqVO[{}]", new Object[]{patientInfoBycredNo.getErrCode(), patientInfoBycredNo.getMsg(), reqVO});
        return BaseResponse.error((IError)ErrorEnum.SAVE_PATIENT_EER);
    }

    public BaseResponse<GetUserLoginInfoRespVO> getUserLoginInfo(GetUserLoginInfoReqVO reqVO) {
        this.log.info("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f \u5165\u53c2\uff1a{}", (Object)reqVO);
        GetUserLoginInfoRespVO userLoginInfoRespVO = new GetUserLoginInfoRespVO();
        UserEntity userEntity = this.getUserEntity(reqVO.getUserId(), reqVO.getUserType());
        userLoginInfoRespVO.setUserId(reqVO.getUserId());
        userLoginInfoRespVO.setUserType(reqVO.getUserType());
        this.getContactMobile(reqVO, userLoginInfoRespVO, userEntity);
        Optional wxAuthOptional = this.ucWxAuthMapper.findByUserIdAndUserTypeAndStatus(reqVO.getUserId(), reqVO.getUserType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        wxAuthOptional.ifPresent(ucWxAuthEntity -> userLoginInfoRespVO.setWechatLoginId(ucWxAuthEntity.getWxOpenid()));
        List userLoginInfoList = this.getUserLoginInfos(reqVO, userEntity);
        userLoginInfoRespVO.setUserLoginInfos(userLoginInfoList);
        this.log.error("\u7528\u6237\u767b\u5f55\u8bb0\u5f55\uff0creqVO[{}],respVO[{}]", (Object)reqVO, (Object)userLoginInfoRespVO);
        return BaseResponse.success((Object)userLoginInfoRespVO);
    }

    private void getContactMobile(GetUserLoginInfoReqVO reqVO, GetUserLoginInfoRespVO userLoginInfoRespVO, UserEntity userEntity) {
        UserEnums.UserTypeEnum userTypeEnum = UserEnums.UserTypeEnum.getByTypeValue((Short)reqVO.getUserType());
        switch (1.$SwitchMap$com$ebaiyihui$server$enums$UserEnums$UserTypeEnum[userTypeEnum.ordinal()]) {
            case 1: {
                UcPatientUserEntity patientUserEntity = (UcPatientUserEntity)userEntity;
                userLoginInfoRespVO.setContactMobile(patientUserEntity.getContactMobile());
                break;
            }
            case 2: {
                UcDoctorUserEntity doctorUserEntity = (UcDoctorUserEntity)userEntity;
                userLoginInfoRespVO.setContactMobile(doctorUserEntity.getContactMobile());
                break;
            }
            case 4: {
                UcOrganUserEntity organUserEntity = (UcOrganUserEntity)userEntity;
                userLoginInfoRespVO.setContactMobile(organUserEntity.getContactMobile());
                break;
            }
        }
    }

    public BaseResponse<List<FindUserIdRespVO>> queryUserIdList(FindUserIdListReq findUserIdListReq) {
        ArrayList<FindUserIdRespVO> findUserIdRespVOList = new ArrayList<FindUserIdRespVO>();
        List findUserIdReqVOList = findUserIdListReq.getFindUserIdReqVOS();
        for (FindUserIdReqVO findUserIdReqVO : findUserIdReqVOList) {
            FindUserIdRespVO findUserIdRespVO;
            Short userType = findUserIdReqVO.getUserType();
            String reqId = findUserIdReqVO.getReqId();
            if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(userType)) {
                findUserIdRespVO = this.findPatientUserIdByPatientId(reqId);
                findUserIdRespVOList.add(findUserIdRespVO);
                continue;
            }
            if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(userType)) {
                findUserIdRespVO = this.findDoctorUserByDoctorId(reqId);
                findUserIdRespVOList.add(findUserIdRespVO);
                continue;
            }
            if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userType)) {
                findUserIdRespVO = this.findManagerUserByBaseId(reqId);
                findUserIdRespVOList.add(findUserIdRespVO);
                continue;
            }
            if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(userType)) {
                findUserIdRespVO = this.findOrganUserByBaseId(reqId);
                findUserIdRespVOList.add(findUserIdRespVO);
                continue;
            }
            findUserIdRespVO = new FindUserIdRespVO();
            findUserIdRespVO.setReqId(reqId);
            findUserIdRespVO.setUsrType(userType);
            this.log.warn("\u7528\u6237\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u7528\u6237\u7c7b\u578buserType{}", (Object)userType);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            findUserIdRespVOList.add(findUserIdRespVO);
        }
        return BaseResponse.success(findUserIdRespVOList);
    }

    private FindUserIdRespVO findOrganUserByBaseId(String organId) {
        Optional optional = this.ucOrganUserMapper.selectByOrganId(organId);
        FindUserIdRespVO findUserIdRespVO = new FindUserIdRespVO();
        findUserIdRespVO.setReqId(organId);
        findUserIdRespVO.setUsrType(UserEnums.UserTypeEnum.ORGAN.getUserTypeValue());
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u673a\u6784\u7528\u6237\u4e0d\u5b58\u5728,BaseId={}", (Object)organId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        UcOrganUserEntity user = (UcOrganUserEntity)optional.get();
        String userId = user.getUserId();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.SUCCESS.getResult());
        findUserIdRespVO.setUserId(userId);
        return findUserIdRespVO;
    }

    private FindUserIdRespVO findManagerUserByBaseId(String reqId) {
        Optional optional = this.ucManagerUserMapper.selectByBaseId(reqId);
        FindUserIdRespVO findUserIdRespVO = new FindUserIdRespVO();
        findUserIdRespVO.setReqId(reqId);
        findUserIdRespVO.setUsrType(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue());
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728,BaseId={}", (Object)reqId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        UcManagerUserEntity user = (UcManagerUserEntity)optional.get();
        String userId = user.getUserId();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.SUCCESS.getResult());
        findUserIdRespVO.setUserId(userId);
        return findUserIdRespVO;
    }

    private FindUserIdRespVO findDoctorUserByDoctorId(String doctorId) {
        Optional optional = this.ucDoctorUserMapper.selectByDoctorId(doctorId);
        FindUserIdRespVO findUserIdRespVO = new FindUserIdRespVO();
        findUserIdRespVO.setReqId(doctorId);
        findUserIdRespVO.setUsrType(UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue());
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u533b\u751f\u7528\u6237\u4e0d\u5b58\u5728,doctorId={}", (Object)doctorId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        UcDoctorUserEntity user = (UcDoctorUserEntity)optional.get();
        String userId = user.getUserId();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.SUCCESS.getResult());
        findUserIdRespVO.setUserId(userId);
        return findUserIdRespVO;
    }

    private FindUserIdRespVO findPatientUserIdByPatientId(String patientId) {
        Optional optionalEntity = this.ucPatientInfoMapper.findByPatientIdAndPatientInfoStatus(patientId, UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        FindUserIdRespVO findUserIdRespVO = new FindUserIdRespVO();
        findUserIdRespVO.setReqId(patientId);
        findUserIdRespVO.setUsrType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue());
        if (!optionalEntity.isPresent()) {
            this.log.warn("\u67e5\u8be2\u60a3\u8005\u7528\u6237\u4e0d\u5b58\u5728,patientId={}", (Object)patientId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        UcPatientInfoEntity ucPatientInfoEntity = (UcPatientInfoEntity)optionalEntity.get();
        String userId = ucPatientInfoEntity.getUserId();
        Optional optional = this.ucPatientUserMapper.findByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u60a3\u8005\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        UcPatientUserEntity user = (UcPatientUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.FAIL.getResult());
            return findUserIdRespVO;
        }
        findUserIdRespVO.setQueryStatus(UserEnums.QueryResultEnum.SUCCESS.getResult());
        findUserIdRespVO.setUserId(userId);
        return findUserIdRespVO;
    }

    private List<UserLoginInfo> getUserLoginInfos(GetUserLoginInfoReqVO reqVO, UserEntity userEntity) {
        LoginDeviceType[] values = LoginDeviceType.values();
        ArrayList<UserLoginInfo> userLoginInfoList = new ArrayList<UserLoginInfo>();
        String secryKey = this.getSecryKey(reqVO.getAppCode());
        for (LoginDeviceType loginDeviceType : values) {
            String tokenKey = Tokenutil.genTokenKey((String)userEntity.getUserId(), (String)reqVO.getAppCode(), (String)loginDeviceType.name());
            String loginToken = this.userICacheService.getLoginToken(tokenKey);
            if (!StringUtils.isNotBlank((CharSequence)loginToken)) continue;
            UserLoginInfo userLoginInfo = new UserLoginInfo();
            try {
                TokenBody tokenBody = Tokenutil.parse((String)loginToken, (String)secryKey);
                TokenJson tokenJson = tokenBody.getTokenJson();
                userLoginInfo.setAccountId(tokenJson.getAccountId());
                userLoginInfo.setChannelCode(tokenJson.getChannelCode());
                userLoginInfo.setDeviceNumber(tokenJson.getDevicenumber());
                userLoginInfoList.add(userLoginInfo);
            }
            catch (TokenParseException e) {
                this.log.error("\u60a3\u8005\u767b\u5f55token\u89e3\u6790\u5931\u8d25\uff0ctokenKey[{}]", (Object)tokenKey);
                throw new UserCenterRuntimeException(ErrorEnum.TOKEN_PARSE_FAIL);
            }
        }
        return userLoginInfoList;
    }

    private BaseResponse<AddPatientInfoRespVO> alreadyPatient(AddPatientInfoReqVO reqVO, UcPatientUserEntity patientUserEntity, PatientInfoRespVO patientInfoRespVO) {
        Optional optionalUcPatientInfoEntity = this.ucPatientInfoMapper.selectByPatientIdAndPatientStatus(patientInfoRespVO.getPatientId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        return optionalUcPatientInfoEntity.map(ucPatientInfoEntity -> this.patientAlreadyBindUser(reqVO, ucPatientInfoEntity)).orElseGet(() -> this.updatePatientAndBind(reqVO, patientUserEntity, patientInfoRespVO));
    }

    private BaseResponse<AddPatientInfoRespVO> updatePatientAndBind(AddPatientInfoReqVO reqVO, UcPatientUserEntity patientUserEntity, PatientInfoRespVO patientInfoRespVO) {
        UpdatePatientInfoReqVO updatePatientInfoReqVO = new UpdatePatientInfoReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)updatePatientInfoReqVO);
        updatePatientInfoReqVO.setPatientId(patientInfoRespVO.getPatientId());
        BaseResponse updatePatientInfo = this.patientServiceFeginClient.updatePatientInfo(updatePatientInfoReqVO);
        if (updatePatientInfo.isSuccess() || PatientErrorEnum.INFO_NOT_UPDATE.getErrCode().equals(updatePatientInfo.getErrCode())) {
            AddPatientInfoRespVO addPatientInfoRespVO = this.getAddPatientInfoRespVO(reqVO, patientUserEntity, patientInfoRespVO.getPatientId());
            this.log.info("\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0cpatientInfoEntity[{}]", (Object)updatePatientInfoReqVO);
            this.messageService.patientActionMsg(addPatientInfoRespVO.getUserId(), addPatientInfoRespVO.getPatientId(), UserEnums.PatientInfoStatusEnum.BINDING);
            UcAccountEntity account = this.getAccountByUserId(reqVO.getUserId(), UserEnums.UserTypeEnum.PATIENT.getUserTypeValue(), reqVO.getAppCode());
            if (account == null) {
                this.log.error("\u60a3\u8005\u4e2d\u5fc3\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u5927\u4f17\u8d26\u6237,userId={},appCode={}", (Object)reqVO.getUserId(), (Object)reqVO.getAppCode());
                return BaseResponse.error((IError)ErrorEnum.NO_EXISTS_ACCOUNT);
            }
            UcPatientOperateEntity patientOperateEntity = new UcPatientOperateEntity(account.getAccountId(), reqVO.getUserId(), addPatientInfoRespVO.getPatientId(), addPatientInfoRespVO.getPatientInfoId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding(), UserEnums.PatientOperatorEnum.USER.getUserType());
            this.ucPatientOperateMapper.save(patientOperateEntity);
            return BaseResponse.success((Object)addPatientInfoRespVO);
        }
        this.log.error("\u60a3\u8005\u4e2d\u5fc3\u4fdd\u5b58\u60a3\u8005\u4fe1\u606f\u5931\u8d25,updatePatientInfo[{}]", (Object)updatePatientInfo);
        return BaseResponse.error((IError)ErrorEnum.SAVE_PATIENT_EER);
    }

    private BaseResponse<AddPatientInfoRespVO> patientAlreadyBindUser(AddPatientInfoReqVO reqVO, UcPatientInfoEntity patientInfoEntity) {
        this.log.info("\u5f53\u524d\u60a3\u8005\u5df2\u7ecf\u88ab\u7ed1\u5b9a\uff0cAddPatientInfoReqVO[{}],patientInfoEntity[{}]", (Object)reqVO, (Object)patientInfoEntity);
        UcPatientUserEntity bindingUserEntity = this.getPatientUserEntity(patientInfoEntity.getUserId());
        String registerMobile = bindingUserEntity.getRegisterMobile();
        StringBuilder returnTel = new StringBuilder(registerMobile);
        StringBuilder replaceTel = returnTel.replace(3, 7, "****");
        String returnMsg = reqVO.getName() + "\u5df2\u88ab" + replaceTel + "\u7ed1\u5b9a,\u60a8\u53ef\u76f4\u63a5\u767b\u5f55\u8d26\u6237\u4f7f\u7528\u6216\u89e3\u7ed1\u540e\u518d\u7ed1\u5b9a";
        return BaseResponse.error((IError)ErrorEnum.PATIENT_ALREADY_BIND, (String)returnMsg);
    }

    private BaseResponse<PatientInfoRespVO> getPatientInfoByCred(AddPatientInfoReqVO reqVO) {
        GetPatientInfoByCrednoReqVO getPatientInfoByCrednoReqVO = new GetPatientInfoByCrednoReqVO();
        getPatientInfoByCrednoReqVO.setCredNo(reqVO.getCredNo());
        getPatientInfoByCrednoReqVO.setCredTypeCode(reqVO.getCredTypeCode());
        getPatientInfoByCrednoReqVO.setAppCode(reqVO.getAppCode());
        getPatientInfoByCrednoReqVO.setChannelCode(reqVO.getChannelCode());
        return this.patientServiceFeginClient.getPatientInfoBycredNo(getPatientInfoByCrednoReqVO);
    }

    private AddPatientInfoRespVO getAddPatientInfoRespVO(AddPatientInfoReqVO reqVO, UcPatientUserEntity patientUserEntity, String patientId) {
        UcPatientInfoEntity patientInfoEntity = new UcPatientInfoEntity();
        patientInfoEntity.setUserId(patientUserEntity.getUserId());
        patientInfoEntity.setPatientId(patientId);
        patientInfoEntity.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        patientInfoEntity.setUserRelation(reqVO.getBindingRelation());
        patientInfoEntity.setCreateTime(new Date());
        this.ucPatientInfoMapper.save(patientInfoEntity);
        AddPatientInfoRespVO addPatientInfoRespVO = new AddPatientInfoRespVO();
        addPatientInfoRespVO.setPatientId(patientId);
        addPatientInfoRespVO.setUserId(patientUserEntity.getUserId());
        addPatientInfoRespVO.setPatientInfoId(patientInfoEntity.getId());
        return addPatientInfoRespVO;
    }

    private List<QueryPatientInfoListRespVO> convertPatientInfoListRespVO(List<PatientInfoListRespVO> patientInfoListRespVOs) {
        return patientInfoListRespVOs.stream().map(pil -> {
            QueryPatientInfoListRespVO queryPatientInfoListReqVO = new QueryPatientInfoListRespVO();
            BeanUtils.copyProperties((Object)pil, (Object)queryPatientInfoListReqVO);
            return queryPatientInfoListReqVO;
        }).collect(Collectors.toList());
    }

    private List<PatientInfoListRespVO> getPatientListReq(List<UcPatientInfoEntity> patientInfoEntities, QueryPatientInfoListReqVO reqVO) {
        PatientInfoListReqVO patientInfoListReqVO = new PatientInfoListReqVO();
        List patientIds = patientInfoEntities.stream().filter(pie -> Objects.equal((Object)pie.getPatientInfoStatus(), (Object)UserEnums.PatientInfoStatusEnum.BINDING.getBinding())).map(UcPatientInfoEntity::getPatientId).collect(Collectors.toList());
        if (patientIds.isEmpty()) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u7ed1\u5b9a\u7684\u60a3\u8005\u4fe1\u606f");
            return Collections.emptyList();
        }
        patientInfoListReqVO.setAppCode(reqVO.getAppCode());
        patientInfoListReqVO.setChannelCode(reqVO.getChannelCode());
        patientInfoListReqVO.setPatientIds(patientIds);
        BaseResponse patientInfoResp = this.patientServiceFeginClient.listPersonByIds(patientInfoListReqVO);
        if (patientInfoResp == null) {
            this.log.error("\u8c03\u7528\u60a3\u8005\u670d\u52a1\u5931\u8d25\uff0c\u8fd4\u56denull");
            throw new UserCenterRuntimeException(ErrorEnum.FEGIN_ERROR);
        }
        if (!patientInfoResp.isSuccess()) {
            this.log.error("\u67e5\u8be2\u60a3\u8005\u670d\u52a1\u5931\u8d25\uff0c\u8fd4\u56de={}", (Object)patientInfoResp);
            throw new UserCenterRuntimeException(ErrorEnum.FEGIN_ERROR);
        }
        return (List)patientInfoResp.getData();
    }

    public UserEntity getUserEntity(String userId, Short userType) {
        UserEnums.UserTypeEnum userTypeEnum = UserEnums.UserTypeEnum.getByTypeValue((Short)userType);
        return this.getUserEntity(userId, userTypeEnum);
    }

    public BaseResponse<DoctorInfoRespVO> queryDoctorByDoctorId(DoctorIdReqVO doctorIdReqVO) {
        UcAccountEntity account = this.getDoctorAccount(doctorIdReqVO.getDoctorId(), doctorIdReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        DoctorInfoRespVO data = new DoctorInfoRespVO();
        data.setUserId(account.getUserId());
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<UserInfoRespVO> queryPatientByPatientId(PatientIdReqVO patientIdReqVO) {
        List list = this.getPatientInfo(patientIdReqVO.getPatientId());
        if (list == null || list.isEmpty()) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}]" + patientIdReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        GetUserInfoReqVO getUserInfoReqVO = new GetUserInfoReqVO();
        getUserInfoReqVO.setAppCode(patientIdReqVO.getAppCode());
        getUserInfoReqVO.setChannelCode(patientIdReqVO.getChannelCode());
        getUserInfoReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue());
        for (UcPatientInfoEntity ucPatientInfoEntity : list) {
            try {
                getUserInfoReqVO.setUserId(ucPatientInfoEntity.getUserId());
                return this.getUserInfo(getUserInfoReqVO);
            }
            catch (Exception e) {
            }
        }
        return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
    }

    public BaseResponse<UserLastLoginDeviceListRespVo> getUserLastLoginDeviceList(UserLastLoginDeviceListReqVo reqVo) {
        this.log.info("\u6839\u636euserIds\u67e5\u8be2\u6700\u8fd1\u767b\u5f55\u8bbe\u5907\u53f7\u96c6\u5408  \u5165\u53c2:{}", (Object)reqVo);
        UserLastLoginDeviceListRespVo listRespVo = new UserLastLoginDeviceListRespVo();
        if (CollectionUtils.isEmpty((Collection)reqVo.getLastLoginDeviceReqList())) {
            return BaseResponse.success((Object)listRespVo);
        }
        LinkedList<UserLastLoginDeviceRespVo> list = new LinkedList<UserLastLoginDeviceRespVo>();
        List reqVoList = reqVo.getLastLoginDeviceReqList();
        for (UserLastLoginDeviceReqVo deviceReqVo : reqVoList) {
            UcLoginRecordEntity recordEntity;
            UcAccountEntity account;
            if (deviceReqVo == null || StringUtils.isEmpty((CharSequence)deviceReqVo.getUserId()) || deviceReqVo.getUserType() == null || (account = this.ucAccountMapper.findByUserIdAndUserType(deviceReqVo.getUserId(), deviceReqVo.getUserType())) == null || (recordEntity = this.ucLoginRecordMapper.selectLastByAccountId(account.getAccountId())) == null) continue;
            UserLastLoginDeviceRespVo respVo = new UserLastLoginDeviceRespVo();
            respVo.setAccountId(recordEntity.getAccountId());
            respVo.setUserId(deviceReqVo.getUserId());
            respVo.setDeviceNumber(recordEntity.getDeviceNumber());
            if (!StringUtils.isNotEmpty((CharSequence)recordEntity.getLoginBussinessCode()) || !StringUtils.contains((CharSequence)recordEntity.getLoginBussinessCode(), (CharSequence)"_")) continue;
            respVo.setDeviceType(recordEntity.getLoginBussinessCode().split("_")[1]);
            list.add(respVo);
        }
        listRespVo.setDecivceList(list);
        this.log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u767b\u5f55\u8bbe\u5907\u53f7 \u6210\u529f \u54cd\u5e94{}", (Object)listRespVo);
        return BaseResponse.success((Object)listRespVo);
    }

    public BaseResponse<UserLastLoginDeviceRespVo> getUserLastLoginDevice(UserLastLoginDeviceReqVo reqVo) {
        this.log.info("\u6839\u636euserId\u67e5\u8be2\u6700\u8fd1\u767b\u5f55\u8bbe\u5907 id:{},userType:{}", (Object)reqVo.getUserId(), (Object)reqVo.getUserType());
        UserLastLoginDeviceRespVo respVo = new UserLastLoginDeviceRespVo();
        UcAccountEntity account = this.ucAccountMapper.findByUserIdAndUserType(reqVo.getUserId(), reqVo.getUserType());
        if (account == null) {
            return BaseResponse.success((Object)respVo);
        }
        UcLoginRecordEntity recordEntity = this.ucLoginRecordMapper.selectLastByAccountId(account.getAccountId());
        if (recordEntity == null) {
            return BaseResponse.success((Object)respVo);
        }
        this.log.info("====recordEntity:{}", (Object)recordEntity);
        respVo.setAccountId(recordEntity.getAccountId());
        respVo.setUserId(reqVo.getUserId());
        respVo.setDeviceNumber(recordEntity.getDeviceNumber());
        if (!StringUtils.isNotEmpty((CharSequence)recordEntity.getLoginBussinessCode()) || !StringUtils.contains((CharSequence)recordEntity.getLoginBussinessCode(), (CharSequence)"_")) {
            this.log.info("\u67e5\u8be2\u7528\u6237\u6700\u8fd1\u767b\u5f55\u8bbe\u5907==\u300b\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u8bbe\u5907\u7c7b\u578b,DeviceType:{}", (Object)recordEntity.getLoginBussinessCode());
            return BaseResponse.error((IError)ErrorEnum.NO_VALID_DEVICE_TYPE_FOUND);
        }
        respVo.setDeviceType(recordEntity.getLoginBussinessCode().split("_")[1]);
        this.log.info("\u6839\u636euserId\u67e5\u8be2\u6700\u8fd1\u767b\u5f55\u8bbe\u5907\u53f7  \u54cd\u5e94:{}", (Object)respVo);
        return BaseResponse.success((Object)respVo);
    }

    public BaseResponse<UserLastLoginDeviceRespVo> getLastLoginWxOpenid(UserLastLoginDeviceReqVo reqVo) {
        this.log.info("\u67e5\u8be2\u6700\u8fd1\u767b\u5f55wxopenid userid:{},userType:{}", (Object)reqVo.getUserId(), (Object)reqVo.getUserType());
        UserLastLoginDeviceRespVo respVo = new UserLastLoginDeviceRespVo();
        UcAccountEntity account = this.ucAccountMapper.findByUserIdAndUserType(reqVo.getUserId(), reqVo.getUserType());
        if (account == null) {
            return BaseResponse.success((Object)respVo);
        }
        UcLoginRecordEntity recordEntity = this.ucLoginRecordMapper.selectLastWxOpenidByAccountId(account.getAccountId());
        if (recordEntity == null) {
            return BaseResponse.success((Object)respVo);
        }
        respVo.setAccountId(recordEntity.getAccountId());
        respVo.setUserId(reqVo.getUserId());
        respVo.setDeviceNumber(recordEntity.getDeviceNumber());
        respVo.setDeviceType(recordEntity.getDeviceType());
        this.log.info("\u6839\u636euserId\u67e5\u8be2\u6700\u8fd1\u767b\u5f55wxopenid  \u54cd\u5e94:{}", (Object)respVo);
        return BaseResponse.success((Object)respVo);
    }

    public BaseResponse<String> getLanguage(String userId) {
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByUserId(userId);
        if (accountEntity != null) {
            this.log.info("\u83b7\u53d6\u7528\u6237\u8bed\u8a00==userid:{},lang:{}", (Object)userId, (Object)accountEntity.getLanguage());
            return BaseResponse.success((Object)accountEntity.getLanguage());
        }
        return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
    }

    public BaseResponse<String> setLanguage(String userId, String language) {
        UcAccountEntity accountEntity = this.ucAccountMapper.selectByUserId(userId);
        if (accountEntity == null) {
            this.log.info("\u8bbe\u7f6e\u8bed\u8a00 --\u7528\u6237\u4e0d\u5b58\u5728 userId:{}", (Object)userId);
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        if (!accountEntity.getLanguage().equals(language)) {
            this.log.info("\u83b7\u53d6\u7528\u6237\u8bed\u8a00==userid:{},lang:{}", (Object)userId, (Object)accountEntity.getLanguage());
            if (LangEnum.LANG_ZH_CN.getLanguage().toLowerCase().contains(language.toLowerCase())) {
                accountEntity.setLanguage(LangEnum.LANG_ZH_CN.getLanguage());
            } else if (LangEnum.LANG_EN_US.getLanguage().toLowerCase().contains(language.toLowerCase())) {
                accountEntity.setLanguage(LangEnum.LANG_EN_US.getLanguage());
            } else if (LangEnum.LANG_JA_JP.getLanguage().toLowerCase().contains(language.toLowerCase())) {
                accountEntity.setLanguage(LangEnum.LANG_JA_JP.getLanguage());
            } else if (LangEnum.LANG_KO_KR.getLanguage().toLowerCase().contains(language.toLowerCase())) {
                accountEntity.setLanguage(LangEnum.LANG_KO_KR.getLanguage());
            } else {
                this.log.info("==\u4e0d\u652f\u6301\u7684\u8bed\u8a00\u7c7b\u578b=={}", (Object)language);
                return BaseResponse.error((IError)ErrorEnum.UNSUPPORTED_LANGUAGE_TYPE);
            }
            this.ucAccountMapper.save(accountEntity);
            return BaseResponse.success((Object)accountEntity.getLanguage());
        }
        return BaseResponse.success((Object)accountEntity.getLanguage());
    }

    public BaseResponse<UserUniqueIdentifyRespVo> getUniqueIdentify(UserUniqueIdentifyReqVo userUniqueIdentifyReqVo) {
        UserUniqueIdentifyRespVo userUniqueIdentifyRespVo = new UserUniqueIdentifyRespVo();
        if (1 == userUniqueIdentifyReqVo.getType()) {
            Optional wxAuthEntityOptional = this.wxAuthMapper.findByUserIdAndUserType(userUniqueIdentifyReqVo.getUserId(), Short.valueOf(userUniqueIdentifyReqVo.getUserType().shortValue()));
            if (!wxAuthEntityOptional.isPresent()) {
                this.log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u7528\u6237\u5fae\u4fe1\u552f\u4e00\u6807\u8bc6,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,userId={},userType={}", (Object)userUniqueIdentifyReqVo.getUserId(), (Object)userUniqueIdentifyReqVo.getUserType());
                return BaseResponse.error((String)"\u67e5\u8be2\u7528\u6237\u5fae\u4fe1\u552f\u4e00\u6807\u8bc6,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            }
            UcWxAuthEntity ucWxAuthEntity = (UcWxAuthEntity)wxAuthEntityOptional.get();
            userUniqueIdentifyRespVo.setType(userUniqueIdentifyReqVo.getType());
            userUniqueIdentifyRespVo.setUniqueIdentify(ucWxAuthEntity.getWxOpenid());
            return BaseResponse.success((Object)userUniqueIdentifyRespVo);
        }
        if (2 == userUniqueIdentifyReqVo.getType()) {
            Optional alipayAuthEntityOptional = this.alipayAuthMapper.findByUserIdAndUserType(userUniqueIdentifyReqVo.getUserId(), userUniqueIdentifyReqVo.getUserType());
            this.log.info("alipayAuthEntityOptional{}", (Object)JSON.toJSONString((Object)alipayAuthEntityOptional));
            if (!alipayAuthEntityOptional.isPresent()) {
                this.log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u7528\u6237\u652f\u4ed8\u5b9d\u552f\u4e00\u6807\u8bc6,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,userId={},userType={}", (Object)userUniqueIdentifyReqVo.getUserId(), (Object)userUniqueIdentifyReqVo.getUserType());
                return BaseResponse.error((String)"\u67e5\u8be2\u7528\u6237\u652f\u4ed8\u5b9d\u552f\u4e00\u6807\u8bc6,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            }
            UcAlipayAuthEntity alipayAuthEntity = (UcAlipayAuthEntity)alipayAuthEntityOptional.get();
            userUniqueIdentifyRespVo.setType(userUniqueIdentifyReqVo.getType());
            userUniqueIdentifyRespVo.setUniqueIdentify(alipayAuthEntity.getAlipayUserId());
            return BaseResponse.success((Object)userUniqueIdentifyRespVo);
        }
        return null;
    }

    public BaseResponse<BaseIdRespVO> getUserInfoByPhone(GetUserInfoByPhoneDTO req) {
        UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByUserTypeAndAppCodeAndStatusAndAccountNoOrRelatedMobileNumber(req.getUserType(), req.getAppCode(), AccountEnums.AccountStatusEnum.NORMAL.getValue(), req.getPhoneNum());
        if (null == ucAccountEntity) {
            this.log.info("getUserInfoByPhone \u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,phoneNum={}", (Object)req.getPhoneNum());
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        BaseIdRespVO baseIdRespVO = new BaseIdRespVO();
        baseIdRespVO.setUserId(ucAccountEntity.getUserId());
        baseIdRespVO.setAccountId(ucAccountEntity.getAccountId());
        return BaseResponse.success((Object)baseIdRespVO);
    }

    private List<UcPatientInfoEntity> getPatientInfo(String patientId) {
        UcPatientInfoEntity patientInfo = new UcPatientInfoEntity();
        patientInfo.setPatientId(patientId);
        patientInfo.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        Example example = Example.of((Object)patientInfo);
        List list = this.ucPatientInfoMapper.selectListByPatientIdAndPatientStatus(patientId, UserEnums.PatientInfoStatusEnum.BINDING.getBinding());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public BaseResponse<Object> realNameAuth(RealNameAuthReqVO realNameAuthReqVO) {
        Optional userOptional = this.ucPatientUserMapper.findByUserId(realNameAuthReqVO.getUserId());
        if (!userOptional.isPresent()) {
            this.log.warn("\u7528\u6237\u4e0d\u5b58\u5728\uff0cuserId: {}", (Object)realNameAuthReqVO.getUserId());
            return BaseResponse.error((IError)ErrorEnum.DATA_NOT_EXIST);
        }
        Optional credNoOptional = this.ucPatientUserMapper.findByCredNo(realNameAuthReqVO.getCredNo());
        if (credNoOptional.isPresent()) {
            this.log.warn("\u8eab\u4efd\u8bc1\u53f7\u5df2\u88ab\u7ed1\u5b9a\uff0ccredNo: {}", (Object)realNameAuthReqVO.getCredNo());
            return BaseResponse.error((IError)ErrorEnum.REAL_NAME_HAS_BAND);
        }
        boolean isMatch = this.verifyIdCardAndName(realNameAuthReqVO);
        UcPatientUserEntity userEntity = (UcPatientUserEntity)userOptional.get();
        if (isMatch) {
            this.updateUserRealNameInfo(userEntity, realNameAuthReqVO);
            this.log.info("\u5b9e\u540d\u8ba4\u8bc1\u6210\u529f\uff0cuserId: {}, name: {}, credNo: {}", new Object[]{realNameAuthReqVO.getUserId(), realNameAuthReqVO.getName(), realNameAuthReqVO.getCredNo()});
            return BaseResponse.success();
        }
        this.log.warn("\u5b9e\u540d\u8ba4\u8bc1\u5931\u8d25\uff0cuserId: {}, name: {}, credNo: {}", new Object[]{realNameAuthReqVO.getUserId(), realNameAuthReqVO.getName(), realNameAuthReqVO.getCredNo()});
        return BaseResponse.error((IError)ErrorEnum.REAL_NAME_DOES_NOT_MATCH_ID_CARD);
    }

    private boolean verifyIdCardAndName(RealNameAuthReqVO realNameAuthReqVO) {
        IdCardValidateResponseVo idCardValidateResponseVo = this.aliCloudIdCardUtil.zkVerifyIdWithNameV2(realNameAuthReqVO.getCredNo(), realNameAuthReqVO.getName());
        this.log.info("\u8eab\u4efd\u8bc1\u6821\u9a8c---\u8c03\u7b2c\u4e09\u65b9\u67e5\u8be2--\u8fd4\u56de\u503c:{}", (Object)idCardValidateResponseVo);
        if (idCardValidateResponseVo == null || !"01".equals(idCardValidateResponseVo.getStatus())) {
            String backupValidationResult = this.aliCloudIdCardUtil.verifyIdWithName(realNameAuthReqVO.getCredNo(), realNameAuthReqVO.getName());
            return StringUtils.isNotEmpty((CharSequence)backupValidationResult);
        }
        return true;
    }

    private void updateUserRealNameInfo(UcPatientUserEntity userEntity, RealNameAuthReqVO realNameAuthReqVO) {
        userEntity.setCredNo(realNameAuthReqVO.getCredNo());
        userEntity.setName(realNameAuthReqVO.getName());
        userEntity.setRealnameStatus(UserEnums.RealnameStatusEnum.REALNAMED.getRealnameStatus());
        this.ucPatientUserMapper.updateById(userEntity);
    }

    public BaseResponse<Object> cancelRealNameAuth(RealNameAuthReqVO realNameAuthReqVO) {
        Optional byUserId = this.ucPatientUserMapper.findByUserId(realNameAuthReqVO.getUserId());
        if (!byUserId.isPresent()) {
            return BaseResponse.error((IError)ErrorEnum.DATA_NOT_EXIST);
        }
        UcPatientUserEntity userEntity = (UcPatientUserEntity)byUserId.get();
        userEntity.setRealnameStatus(UserEnums.RealnameStatusEnum.UNREALNAME.getRealnameStatus());
        this.ucPatientUserMapper.updateById(userEntity);
        return BaseResponse.success();
    }
}

