/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.push;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.push.AliSmsSendAuthCodeReqPhoneVo;
import com.ebaiyihui.server.push.GetPushConfigurationResVo;
import com.ebaiyihui.server.push.SmsSendAuthCodeRsp;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PushService {
    private static final Logger log = LoggerFactory.getLogger(PushService.class);
    @Autowired
    private ProjProperties projProperties;
    private static final String GET_SMS_CALL = "/cloud/push/alismsapi/sendAuthCodeWithPhone";
    private static final String GET_PUSH_CONFIG_URL = "/cloud/doctoruser/configuration/getdetail";

    public GetPushConfigurationResVo getSingleClientCode(String appCode, String type) {
        String clientCodeString = this.getPushConfiguration(appCode, type);
        if (StringUtils.isEmpty((Object)clientCodeString)) {
            return new GetPushConfigurationResVo();
        }
        log.info("\u77ed\u4fe1\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503c:{}" + clientCodeString);
        GetPushConfigurationResVo getPushConfigurationResVo = new GetPushConfigurationResVo();
        GetPushConfigurationResVo clientCodeObject = (GetPushConfigurationResVo)JSONObject.parseObject((String)clientCodeString, GetPushConfigurationResVo.class);
        log.info("\u4ece\u63a8\u9001\u914d\u7f6e\u4e2d\u83b7\u53d6\u77ed\u4fe1\u7684clientCode:{}" + JSON.toJSONString((Object)clientCodeObject));
        getPushConfigurationResVo.setDoctorCode(clientCodeObject.getSignCode().getDoctorCode());
        getPushConfigurationResVo.setPatientCode(clientCodeObject.getSignCode().getPatientCode());
        getPushConfigurationResVo.setClientCode(clientCodeObject.getClientCode());
        log.info("\u83b7\u53d6\u5230\u7684ClientCode-doctorCode-patientCode:{}" + JSON.toJSONString((Object)getPushConfigurationResVo));
        return getPushConfigurationResVo;
    }

    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhone(AliSmsSendAuthCodeReqPhoneVo aliSmsSendAuthCodeReqPhoneVO) {
        try {
            String smsPush = this.projProperties.getEbaiyihuiDomain() + GET_SMS_CALL;
            String body = HttpKit.jsonPost((String)smsPush, (String)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse:{} " + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u77ed\u4fe1\u914d\u7f6e\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
    }

    private String getPushConfiguration(String appCode, String type) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("appCode", appCode);
        map.put("type", type);
        log.info("\u83b7\u53d6\u63a8\u9001code\u5165\u53c2map:", (Object)JSON.toJSONString(map));
        String url = this.projProperties.getEbaiyihuiDomain() + GET_PUSH_CONFIG_URL;
        String clientCodeData = null;
        try {
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString(map));
            GetPushConfigurationResVo getPushConfigurationResVo = (GetPushConfigurationResVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), GetPushConfigurationResVo.class);
            if (null == getPushConfigurationResVo || null == getPushConfigurationResVo.getData()) {
                return "";
            }
            log.info("\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503c: {}", (Object)getPushConfigurationResVo.getData());
            clientCodeData = getPushConfigurationResVo.getData().getClientCode();
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u63a8\u9001code\u5f02\u5e38{} ", (Throwable)e);
        }
        return clientCodeData;
    }
}

